//=====================================================
// MPConvoMover
//=====================================================
Class MPConvoMover extends DeusExMover;

enum convType
{
	Personal,
	Cooperative
};

var() convType missionType;
var() int missionNumber;
var() int checkMissionState;
var() int setMissionState;
var() string doorOpenMessage;
var float coolDown;
var bool bCoop;

enum stateRange0 //enum seems unnecessary, but it's easier to understand in the editor
{
	Exactly,
	To_value2
//	Above, //this is more complicated to implement than simply using "from 1 to 99999"
//	Below  //same deal, inversely (same thing, even)
};

var() stateRange0 checkRange;
var() int checkValue2;

function Frob(Actor Frobber, Inventory frobWith)
{
	local MissionProgress A;
	local actor A2;

	if(missionNumber != 0)
	{
		if(coolDown <= Level.TimeSeconds)
		{	
			coolDown = Level.TimeSeconds + 0.5; //don't let spammy players cause lag

			foreach AllActors(class 'MissionProgress', A)
			{
				if(A.Owner == Frobber)
				{
					switch (checkRange)
					{
						case Exactly:

						if(checkMissionState == A.GetMissionState(missionNumber, bCoop))
						{
							A.SetMissionState(missionNumber,setMissionState, bCoop);
							Super.Frob(Frobber, frobWith);
							DeusExPlayer(Frobber).ClientMessage(doorOpenMessage);
	
							if(Event != '')
							{
								foreach AllActors(class 'Actor', A2, Event)
								{
									A2.Trigger(Self,Instigator);
								}
							}
						}

						break;

						case To_value2:

						if((checkMissionState <= A.GetMissionState(missionNumber, bCoop)) && (checkMissionState >= A.GetMissionState(missionNumber, bCoop)))
						{
							A.SetMissionState(missionNumber,setMissionState, bCoop);
							Super.Frob(Frobber, frobWith);
							DeusExPlayer(Frobber).ClientMessage(doorOpenMessage);
	
							if(Event != '')
							{
								foreach AllActors(class 'Actor', A2, Event)
								{
									A2.Trigger(Self,Instigator);
								}
							}
						}

						break;
					}
				}
			}
		}
	}
}

function BeginPlay()
{
	if(missionType == Cooperative)
	{
		bCoop = true;
	}

	Super.BeginPlay();
}

defaultproperties
{
     setMissionState=-999
}
